

 
 /***************************************************************************************************************
  *                          Example_2. ET-REMOTE MP3 COMMAND-Mode By Read Play Time                            *
  ***************************************************************************************************************
  *                                                                                                             *
  * Target MCU           : STM8S208MB(ET-BASE STM8S208)                                                         *
  *       	             : USE Internal Clock HSI: 16 MHz                                                       *                                                              
  *                                                                                                             *
  * Editor               : STD V4.1.5                                                                           *
  * Compiler             : COSMIC CXSTM8_16K V4.2.8                                                             *
  * Firmware library     : V1.1.1 update (06/05/2009)                                                           *
  *																				                                                                      *
  * Port Interface       :                                                                                      *
  *																											                                                        *
  *                      : # MCU-STM8S208 #                 # ET-REMOTE MP3 #                                   *
  *                        ----------------                 -----------------                                   * 
	* UART0(RS232)         : PA4(Rx1)            connect              Tx                                          *
  *                        PA5(Tx1)            connect 			        Rx                                          *
	*                        GND                 connect             GND                                          *    
	*            	           Baud Rate 9600                                                                       *
  * 																									                                                          *
  *             3.3V                                                                                            *
  *             -+-                                                                                             *
  *              |                                                                                              *
  *              +------------------+                                                                           *
  *              |                  |                                      -DIP SW.MODE                         *
  *              |                  |                                       S1=ON ; S2=ON                       *
  *              |                  |                 ET-REMOTE MP3 V2     -DIP SW.CONFIG                       *
  *       +------+------+           |               +-------------------+   S1=ON ; S2=OFF                      *
  *       |             |       +---+---+   +---+   |                   |   BR:9600                             *
  *       |             |       |       |   |   |   |RS232(have-Max232) |                                       *
  *       |             | RX1   |       |   |   |   |----+              |                                       *
  *       |         PA4 +-------|RxI RxO|<--|-+ +-->|*Rx||              |        /|                             *   
  *       |             | TX1   |       |   | |     |   ||              |      /  |                             *
  *       |         PA5 +-------|TxI TxO|---+ +-----|*Tx||              +----||   |                             *
  *       |             |       |       |           |   ||              |    || SP|                             *
  *       |             |       |MAX232 |       +---+*G ||              +----||   |                             *
  *       |             |       +---+---+       |   |----+   [Power]    |      \  |                             *
  *       |   STM8S208  |           |           |   |                   |        \|                             * 
  *       +------+------+           |           |   |         G  5V     |                                       *
  *              |                  |           |   +---------+---+-----+                                       * 
  *              |                  |           |             |   |                                             *
  *              +------------------+-----------+             |   +--->5V                                       *
  *              |                                            |                                                 *
  *            --+--                                        --+--                                               *
  *             ---                                          ---                                                *
  *              -                                            -                                                 *
  *                                                                                                             *
  * Test Operate    : For Test Program in Micro SD Card must have File Name 'A23_FT1.MP3' and                   *
  *                   'A23_FT2.MP3' ;... Begin Set Command For Show play Time then Play File                    *
  *                   Name 'A23_FT1.MP3' is time 30 sec. and chang play File Name                               *
  *                   'A24_FT2.MP3' is time 1 minute ,Then Return play New first file                           *
  *                                                                                                             *
	*                                                                                                             *
  *                                                                                                             *
  * File Libary(src) Add : 1. stm8s_UART1.c                                                                     *
  *                        2. stm8s_gpio.c                                                                      *
  *                        3. stm8s_clk.c                                                                       *
	*                        4. stm8s_tim4.c                                                                      *
  *                                                                                                             *
  *                                                                                                             *
  * Create By            : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                                 *
  * Last Update          : 11/June/2012                                                                         *
  *                                                                                                             *
  ***************************************************************************************************************/

 
#include "stm8s.h"
#include "stdio.h"
 
char Buf_Time[5]  ; 
unsigned int counter ;

  /**************************************************************************** 
	 *     <----- Retargets the C library printf function to the UART1. ------> *
   *                                                                          *
   *  Library functions called:                                               *
   *                           - UART1_GetFlagStatus(UART1_FLAG_TC)           *
	 *                           - UART1_SendData8()                            *
   ****************************************************************************/

 char putchar (char c)
  {

    if (c == '\n')
    {
			/* put '\r' to hardware here */
			/* Wait transmission is completed : otherwise the first data is not sent */
			while (!UART1_GetFlagStatus(UART1_FLAG_TC));
			UART1_SendData8('\r');
			/* Wait transmission is completed */
			while (!UART1_GetFlagStatus(UART1_FLAG_TC));
	  }
    /* put c to hardware here */
    /* Wait transmission is completed : otherwise the first data is not sent */
    while (!UART1_GetFlagStatus(UART1_FLAG_TC));
    UART1_SendData8(c);
    /* Wait transmission is completed */
    while (!UART1_GetFlagStatus(UART1_FLAG_TC));


    return (c);
  }


/*************************************************************************
 *  <---- Retargets the C library getchar function from the UART1 ---->  *
 *                                                                       *
 *    Library functions called:                                          *
 *                           - UART1_GetFlagStatus(UART1_FLAG_RXNE)      *
 *                           - UART1_ReceiveData8()                      *
 *************************************************************************/
char getchar (void)
{
	  while (!UART1_GetFlagStatus(UART1_FLAG_RXNE)); //check Read Data Register Not Empty flag
    return (UART1_ReceiveData8())                ;
}


/***************************************************
 *                   Function delay ms 		    	   *
 ***************************************************/

void delay (void)
{
	char i  ;
  for(i=0;i<2;i++){;} 
	  
}


void delay_ms(unsigned int ms)
{ 
	counter=0                     ;
	TIM4_Cmd(ENABLE)              ;     //Start Time4	
  while(counter!= ms){delay();}
	TIM4_Cmd(DISABLE)             ;    //Stop Time4	
	
}


/*************************************************************************
 *            Function Initial Timer4 Control for delay                  *
 *     Max CPU Freq = 16 MHz                                             *
 *     Prescaler to divide Fcpu by = 128                                 *
 *     Freq-Clock = 16MHz/128 =  0.125 MHz= 8 us/clock.                  *
 *************************************************************************/


//------------------------ Initial Timer4 For Delay Interrupt every 1 ms ----------------------

 void Init_Timer4(void)
  {
		TIM4_DeInit()                             ;   //clear overflow flag 
    TIM4_TimeBaseInit(TIM4_PRESCALER_128,125) ;   //Freq master/128 ,Perioid = 125x8us =1 ms
    TIM4_ITConfig(TIM4_IT_UPDATE,ENABLE)      ;   //Enable interrupt
		enableInterrupts()                        ;   // Enable general interrupts 
 
	}



 /*********************************************
  *              Initial UART1                *
	*********************************************
	* UART1 configured as follow:               *
  *        - BaudRate = 9600 baud             *
  *        - Word Length = 8 Bits             *
  *        - One Stop Bit                     *
  *        - No parity                        *
  *        - Receive and transmit enabled     *
	*        - UART1 Clock disabled             *
	*                                           *
  *********************************************/

 void Init_UART1(void)
  {
    UART1_DeInit();  //Set the UART1 peripheral registers to their default reset values
		UART1_Init(9600,UART1_WORDLENGTH_8D,UART1_STOPBITS_1,UART1_PARITY_NO,UART1_SYNCMODE_CLOCK_DISABLE,UART1_MODE_TXRX_ENABLE);
	
  }
 
 
 
 
/*************************************************************************************
 **                 Check Respond Command  From Board MP3                           **
 *************************************************************************************/

//-------------- Check Echo Command (#OK)----------------

void Echo_Cmm(void)
 {
   char buf_cmm[2] ;
   char n,ch ;
   
   do
    {
      do
       {  
         ch = getchar()  		            ; //Read Data
		 
       }while(ch != '#')                ; //Check Byte Start of Echo cmm('#')

      for(n=0;n<2;n++)                    //if ch = # then Keep cmm 2 byte(Keep 'OK')
       {
         buf_cmm[n] = getchar()         ; //Keep Data 'OK' 
       }
     
    }while((buf_cmm[0]!='O')&&(buf_cmm[1]!='K')) ; //Check Echo Command = 'OK' Exit Loop
 }


/*******************************************************
 *                  Read Play Time                     *
 *           Buf_Time[0] = Ascii Minute Byte High      *
 *           Buf_Time[1] = Ascii Minute Byte Low       *
 *           Buf_Time[2] = Ascii :                     *
 *           Buf_Time[3] = Ascii Secound Byte High     *
 *           Buf_Time[4] = Ascii Secound Byte Low      *
 *******************************************************/

void RD_Time(void)
 {
    unsigned char ch,n ;

      do
       {
         ch = getchar() 				           ; //Read Dat
       }while(ch !='@')                    ; //Check Byte Start of Echo cmm('@')

      for(n=0;n<5;n++)                       //if ch = @ then Keep data 5 byte(MM:SS)
       {
         Buf_Time[n] = getchar()           ; //Read Data 'MM:SS' 
	
       }   
 }


/**********************************************************************
 **                                                                  **
 **                         main Program                             **
 **                                                                  **
 **********************************************************************/
 
 main(void) 
  {
    unsigned char enter=0x0D  ;

    Init_UART1()              ;
		Init_Timer4()             ;
    delay_ms(800)             ;  //delay for Sync Borad MP3 Ready 

    //------------------- Begin Sent Command --------------------
  
    printf("*CF=001%c",enter)      ;   //Sent CMM Config. Play[000] =0:Play Instantly ,0:Play 1 Round ,1: Display Time
    Echo_Cmm()                     ;   //Check CMM'#OK'

   //------------- Loop Play file by Name -----------
      
	  while(1)
		{
			printf("*P2=A23_FT1.MP3%c",enter)        ;   //Sent CMM Play File by Name : 'A23_FT1.MP3'
			Echo_Cmm()                               ;   //Check CMM'#OK'
	  
	    do
	     {
	      RD_Time()                              ;   //Read Playing Time    
		   }while((Buf_Time[0]!='0')||(Buf_Time[1]!='0')||(Buf_Time[3]!='3')||(Buf_Time[4]!='0'))  ;  //Check Play File to 00.30 sec. Give Chang play File    
	  
	
		  printf("*P2=A24_FT2.MP3%c",enter)        ;   //Sent CMM Play File by Name : 'A24_FT2.MP3'
	    Echo_Cmm()                               ;   //Check CMM'#OK'

      do
	     {
				 RD_Time()                             ;   //Read Playing Time   
			 }while((Buf_Time[0]!='0')||(Buf_Time[1]!='1')||(Buf_Time[3]!='0')||(Buf_Time[4]!='0'))  ; //Check Play File to 01.00 minit. Give Chang play File      
		
		}  // Return Play File New
  }



 



#ifdef USE_FULL_ASSERT

/**
  * @brief  Reports the name of the source file and the source line number
  *   where the assert_param error has occurred.
  * @param file: pointer to the source file name
  * @param line: assert_param error line source number
  * @retval : None
  */
void assert_failed(u8* file, u32 line)
{ 
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
  }
}
#endif






